const { registerPaymentMethod } = window.wc.wcBlocksRegistry;
const { getSetting } = window.wc.wcSettings;
const { decodeEntities } = window.wp.htmlEntities;
const { createElement } = window.wp.element;

const settings = getSetting('digikash_data', {});
const siteInfo = settings.site_info || {};

const defaultLabel = 'DigiKash';
const label = decodeEntities(settings.title) || defaultLabel;

const Content = () => {
    // Compact container with minimal styling
    const containerStyle = {
        background: '#f8f9fa',
        border: '1px solid #dee2e6',
        borderRadius: '6px',
        padding: '12px 16px',
        margin: '8px 0',
        fontSize: '14px',
        fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif'
    };

    // Compact header - single line with logo and text
    const headerStyle = {
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'space-between',
        marginBottom: '8px'
    };

    const leftSectionStyle = {
        display: 'flex',
        alignItems: 'center',
        gap: '8px',
        flex: 1
    };

    const logoStyle = {
        width: '24px',
        height: '24px',
        borderRadius: '4px',
        flexShrink: 0
    };

    const titleStyle = {
        margin: 0,
        fontSize: '15px',
        fontWeight: '600',
        color: '#212529'
    };

    const securityBadgeStyle = {
        background: '#28a745',
        color: 'white',
        padding: '2px 8px',
        borderRadius: '12px',
        fontSize: '10px',
        fontWeight: '600',
        display: 'flex',
        alignItems: 'center',
        gap: '4px'
    };

    // Compact feature row - single line
    const featuresStyle = {
        display: 'flex',
        alignItems: 'center',
        gap: '12px',
        fontSize: '11px',
        color: '#6c757d',
        marginBottom: settings.testmode ? '8px' : '0'
    };

    const featureStyle = {
        display: 'flex',
        alignItems: 'center',
        gap: '3px'
    };

    // Compact test mode alert (if needed)
    const testModeStyle = {
        background: '#fff3cd',
        border: '1px solid #ffeaa7',
        borderRadius: '4px',
        padding: '6px 10px',
        display: 'flex',
        alignItems: 'center',
        gap: '6px',
        fontSize: '12px',
        color: '#856404'
    };

    return createElement('div', { style: containerStyle }, [
        // Compact header with logo, title, and security badge
        createElement('div', { key: 'header', style: headerStyle }, [
            createElement('div', { key: 'left', style: leftSectionStyle }, [
                // Logo (if available)
                siteInfo.logo && createElement('img', {
                    key: 'logo',
                    src: siteInfo.logo,
                    alt: 'DigiKash',
                    style: logoStyle
                }),
                // Title
                createElement('div', { key: 'title', style: titleStyle }, 
                    siteInfo.gateway_name || 'DigiKash'
                )
            ]),
            // Security badge
            createElement('div', { key: 'security', style: securityBadgeStyle }, [
                createElement('span', { key: 'icon' }, '🔒'),
                'Secure'
            ])
        ]),

        // Compact features in single line
        createElement('div', { key: 'features', style: featuresStyle }, [
            createElement('div', { key: 'feature1', style: featureStyle }, [
                createElement('span', { key: 'icon1' }, '⚡'),
                'Instant'
            ]),
            createElement('div', { key: 'feature2', style: featureStyle }, [
                createElement('span', { key: 'icon2' }, '🛡️'),
                'SSL Protected'
            ]),
            createElement('div', { key: 'feature3', style: featureStyle }, [
                createElement('span', { key: 'icon3' }, '🌍'),
                'Global'
            ])
        ]),

        // Compact test mode alert (only if test mode)
        settings.testmode && createElement('div', { key: 'test-mode', style: testModeStyle }, [
            createElement('span', { key: 'icon' }, '⚠'),
            'Sandbox Mode - Test payment only'
        ])
    ]);
};

const Label = ({ components }) => {
    const { PaymentMethodLabel } = components;
    
    // Compact label with small logo
    if (siteInfo.logo) {
        return createElement('div', { 
            style: { 
                display: 'flex', 
                alignItems: 'center', 
                gap: '6px',
                fontSize: '15px',
                fontWeight: '600'
            } 
        }, [
            createElement('img', {
                key: 'label-logo',
                src: siteInfo.logo,
                alt: 'DigiKash',
                style: { 
                    width: '20px', 
                    height: '20px', 
                    borderRadius: '3px',
                    objectFit: 'contain'
                }
            }),
            createElement('span', { key: 'label-text' }, label)
        ]);
    }
    
    return createElement(PaymentMethodLabel, { text: label });
};

registerPaymentMethod({
    name: "digikash",
    label: createElement(Label),
    content: createElement(Content),
    edit: createElement(Content),
    canMakePayment: () => true,
    ariaLabel: label,
    supports: {
        features: settings.supports || ['products']
    }
});
